functions{
  real factorial(int m);
  real factorial(int m) {
    if (m == 0)
      return 1;
    else
      return (m * factorial(m-1));
  }
  
  matrix matrix_pow(matrix a, real n);
  matrix matrix_pow(matrix a, real n) {
    if (n == 0){
      return diag_matrix(rep_vector(1, rows(a)));
    }
    else
      return a * matrix_pow(a, n - 1);
  }
  
  matrix expmt(matrix mat, real t){
    matrix[rows(mat),rows(mat)] out;
    out<-diag_matrix(rep_vector(1.0, rows(mat)));
    for(i in 1:50){
      out<-out+ matrix_pow(mat,i) * t^i /factorial(i);
    }
    return out;
  }
  
  matrix expmp(matrix A, matrix padeC, vector padeCbig){
    int n;
    real nA;
    real colsum;
    int l;
    matrix[4,10] C;
    vector[4] t;
    matrix[rows(A),rows(A)] I;
    matrix[rows(A),rows(A)] P;
    matrix[rows(A),rows(A)] U;
    matrix[rows(A),rows(A)] V;
    matrix[rows(A),rows(A)] X;
    
    vector[14] Cbig;
    real s;
    real si;
    matrix[rows(A),rows(A)] B;
    matrix[rows(A),rows(A)] B2;
    matrix[rows(A),rows(A)] B4;
    matrix[rows(A),rows(A)] B6;
    matrix[rows(A),rows(A)] A2;
    
    si <- 0;
    C <- padeC;
    Cbig <- padeCbig;
    
    n <-rows(A);
    if(n != cols(A)) print("expmp: Matrix not square!")
    
    if (n <= 1) X <- exp(A);
    else{
      
      // nA <- Matrix::norm(A, "1")
      nA <- 0;
      for(coli in 1:n){
        colsum<-0;
        for(rowi in 1:n){
          colsum<-colsum+fabs(A[rowi,coli]);
        }
        if(colsum > nA) nA <- colsum;
      }
      
      I <- diag_matrix(rep_vector(1,n));
      if (nA <= 2.1) {
        t[1] <- 0.015; t[2]<- 0.25; t[3]<- 0.95; t[4]<- 2.1;
        
        //l <- which.max(nA <= t)
        for(ti in 1:4){
          if(l==0){
            if(nA <= t[ti]) l <- ti;
          }
        }
        
        A2 <- A * A;
        P <- I;
        U <- C[l, 2] * I;
        V <- C[l, 1] * I;
        for (k in 1:l) {
          P <- P * A2;
          U <- U + C[l, (2 * k) + 2] * P;
          V <- V + C[l, (2 * k) + 1] * P;
        }
        U <- A * U;
        X <- inverse(V - U) * (V + U);
      }
      
      else {
        s <- log2(nA/5.4);
        B <- A;
        if (s > 0) {
          s <- ceil(s);
          B <- B/(2^s);
        }
        
        B2 <- B * B;
        B4 <- B2 * B2;
        B6 <- B2*B4;
        U <- B*(B6*(Cbig[14] * B6 + Cbig[12] * B4 + Cbig[10] * B2) + Cbig[8] * B6 + Cbig[6] * B4 + Cbig[4] * B2 + Cbig[2] * I);
        V <- B6*(Cbig[13] * B6 + Cbig[11] * B4 + Cbig[9] * B2) + Cbig[7] * B6 + Cbig[5] * B4 + Cbig[3] * B2 + Cbig[1] * I;
        X <- inverse(V - U) * (V + U);
        
        if (s > 0) {
          while (si < s){
            si <- si + 1;
            X <- X * X;
          }
        }
      }
      
    }
    return X;
  }
  
  matrix kron_prod(matrix mata, matrix matb){
    int m;
    int p;
    int n;
    int q;
    matrix[rows(mata)*rows(matb),cols(mata)*cols(matb)] C;
    m<-rows(mata);
    p<-rows(matb);
    n<-cols(mata);
    q<-cols(matb);
    for (i in 1:m){
      for (j in 1:n){
        for (k in 1:p){
          for (l in 1:q){
            C[p*(i-1)+k,q*(j-1)+l] <- mata[i,j]*matb[k,l];
          }
        }
      }
    }
    return C;
  }
  
}
data {
  matrix[4,10] padeC;
  vector[14] padeCbig;
  int<lower=1> N;
  int<lower=1> D_N;
  int<lower=1,upper =2> states[N];
  int<lower=1,upper =2> D_states[D_N];
  int<lower=1,upper =2> D_C_states[D_N-1];
  real<lower=0> time[N-1];
  real<lower=0> D_time[D_N-1];
  
}
parameters{
  real<lower = 0, upper = 20> inten[2];
  simplex[2]D_CPT[2,2];                               // CPTs for Pump
}
model{
  matrix[2,2] A;
  matrix[2,2] B;
  matrix[2,2] C;
  real gamma[N-1];
  real gammaD[D_N-1];
  vector[2]dis;
  vector[2] alpha;
  alpha[1] <- 1;
  alpha[2] <- 1;
  for(i in 1:2)
  {
    inten[i] ~ gamma(2,2);
    for(j in 1:2)
    D_CPT[i,j] ~ dirichlet(alpha);
  }
  // print("D_CPT[1,2,1]=", D_CPT[1,2,1],"D_CPT[1,2,2]=", D_CPT[1,2,2])
  A[1,1] <--inten[1];
  A[1,2] <-inten[1];
  A[2,1] <-inten[2];
  A[2,2] <--inten[2];
  
  for(i in 1:(N-1))
  {
    B <- expmp(A*time[i], padeC, padeCbig);
    // print("B[states", i,"]= ",B[states[i]]);   
    gamma[i] <- categorical_log(states[i+1],to_vector(B[states[i]]));
  }
  for(i in 1:(D_N-1))
  {
    C <- expmp(A*D_time[i], padeC, padeCbig);
    // print("D_CPT[1,D_states[i],1]=",D_CPT[1,D_states[i],1],"D_CPT[1,D_states[i],2]=",D_CPT[1,D_states[i],2] );
    dis[1] <- D_CPT[1,D_states[i],1]*C[D_C_states[i],1] + D_CPT[2,D_states[i],1]*C[D_C_states[i],2];
    dis[2] <- D_CPT[1,D_states[i],2]*C[D_C_states[i],1] + D_CPT[2,D_states[i],2]*C[D_C_states[i],2];
    // dis[2] <- 1 - dis[1];
    gammaD[i] <- categorical_log(D_states[i+1], dis);
  }
  increment_log_prob(gamma);
  increment_log_prob(gammaD);
  
  
  
}




